IF OBJECT_ID('dbo.CD_Lista_Blanca_Suprema', 'U') IS NULL
BEGIN
    CREATE TABLE dbo.CD_Lista_Blanca_Suprema(
        Id_LBS INT IDENTITY(0,1),
        Id_Grupo_Suprema SMALLINT NULL,
        Fecha_Proceso DATETIME NULL,
        Id_Cliente INT NULL,
        Mensaje VARCHAR(5000) NULL,
        CONSTRAINT PKX_CDLB_PorID PRIMARY KEY NONCLUSTERED (Id_LBS)
    )
END
GO


IF IndexProperty(Object_ID('dbo.CD_Lista_Blanca_Suprema'), 'IX_CDLB_PorCli', 'IndexID') IS NULL
BEGIN
    CREATE CLUSTERED INDEX IX_CDLB_PorCli ON CD_Lista_Blanca_Suprema (Id_Cliente)
END

IF NOT EXISTS (
    SELECT 1 
    FROM sys.foreign_keys 
    WHERE name = 'FK_CDLBS_Clientes' 
      AND parent_object_id = OBJECT_ID('dbo.CD_Lista_Blanca_Suprema')
)
BEGIN
    ALTER TABLE dbo.CD_Lista_Blanca_Suprema
    ADD CONSTRAINT FK_CDLBS_Clientes
        FOREIGN KEY (Id_Cliente)
        REFERENCES Clientes (Id_Cliente)
END

GO

